<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Statement - {{ $date }}</title>
    <style>
        * {
            font-family: sans-serif;
            font-size: 12px;
        }

        body {
            padding: 30px;
        }

        .header, .account-info, .customer-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .logo img {
            width: 150px;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .table th, .table td {
            border: 1px solid #000;
            padding: 5px;
        }

        .table th {
            background: #f0f0f0;
        }

        h3, h4 {
            margin: 0;
            padding: 0;
        }

        .title {
            margin-bottom: 15px;
        }

        .account-holder p, .customer-info p {
            margin: 2px 0;
        }

        .small {
            font-size: 10px;
        }

        .bold {
            font-weight: bold;
        }

        .table-compact tr td {
            white-space: nowrap;
            font-size: 13px;
            line-height: 1.2;
            padding: 4px 6px; /* tighter spacing */
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo">
            <img src="{{ $company_logo }}" alt="{{$title}}">
        </div>
        <div class="text-right">
            <h3>Statement of Account</h3>
            <p style="margin:10px 0 0 0;"><strong>{{ $title }}</strong></p>
            <p style="margin:2px 0;"><strong>Phone:</strong> {{ $phone }}</p>
            <p style="margin:2px 0;"><strong>Email:</strong> {{ $email }}</p>
        </div>
    </div> 

    <div class="customer-info">
        <div>
            <p><strong>{{$user_name}}</strong></p>
            <p>{{$user_address}}</p>
            {{-- <p><strong>Phone:</strong> {{$user_phone ?? 'N/A'}}</p> --}}
            <p><strong>Account Number:</strong> {{$account_number ?? 'N/A'}}</p>
            <p><strong>Account Type:</strong> {{ucFirst($account_type ?? 'N/A')}}</p>
        </div>
        <div class="text-right">
            <p><strong>Print Date:</strong> {{ date('d-M-Y') }}</p>
            <p><strong>Period From:</strong> {{ \Carbon\Carbon::parse(request('from'))->format('d-M-Y') }}</p>
            <p><strong>Period To:</strong> {{ \Carbon\Carbon::parse(request('to'))->format('d-M-Y') }}</p>
            <p><strong>Currency:</strong> {{ $currency_name }}</p>
        </div>
    </div>

    <div class="title">
        <h4 class="text-center">ACCOUNT ACTIVITY</h4>
    </div>

    <table class="table table-compact">
        <thead>
        <tr>
            <th>@lang('S/N')</th>
            <th>@lang('Date')</th>
            <th>@lang('Type')</th>
            <th>@lang('Txnid')</th>
            <th>@lang('Sender')</th>
            <th>@lang('Receiver')</th>
            <th>@lang('Debit')</th>
            <th>@lang('Credit')</th>
            <th>@lang('Charge')</th>
            <th>@lang('Available Balance')</th>
        </tr>
        </thead>
        <tbody>
            @forelse ($transactions as $key => $data)
                <tr style="white-space: nowrap; font-size: 13px; line-height: 1.2;">
                <td>{{ $loop->iteration }}</td>
                <td>{{ \Carbon\Carbon::parse($data->created_at)->format('d-M-Y h:i A') }}</td>

                <td>{{ strtoupper($data->type) }}</td>

                <td>{{ $data->txnid }}</td>
                <td>{{ $data->sender_user ? $data->sender_user->account_number : '-' }}</td>
                <td>{{ $data->receiver_user ? $data->receiver_user->account_number : '-' }}</td>

                <td class="text-end">
                    {{ $data->profit !== 'plus' ? showprice($data->amount, $currency) : '0.00' }}
                </td>

                <td class="text-end">
                    {{ $data->profit === 'plus' ? showprice($data->amount, $currency) : '0.00' }}
                </td>

                <td class="text-end">
                    {{ auth()->user()->id == $data->user_id ?  showprice($data->charge, $currency)   : "0.00" }}
                </td>

                <td class="text-end">
                    {{ auth()->user()->id == $data->user_id ?   strtoupper($data->user_available_balance)  : strtoupper($data->receiver_available_balance) }}
                </td>
            </tr>

            @empty
                <tr>
                    <td colspan="6" class="text-center">@lang('NO DATA FOUND')</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>